
//==============================================================================
// Project:		Wealth transfers and their economic effects
// File name:	Table B.5 part b
// Objective: 	Generate the data underpinning the pooled component of table B.5
//
//==============================================================================

clear all

************************
*** Data import ***
************************

cd "XXXX" //set content directory here

use combined_filtered_restricted.dta, replace

merge m:1 wave using CPI.dta //CPI data
drop if _merge == 2
drop _merge

merge m:1 xwaveid using replicate_weights.dta //replicate weights
drop if _merge == 2
drop _merge

merge m:1 xwaveid wave using bequest_from_HH_death.dta //flag for inheritances due to HH deaths
drop if _merge == 2
drop _merge 

xtset xwaveid wave

************************
*** Create variables ***
************************

replace oifinha = 0 if oifinha == -10 | oifinha == -1 //inheritances
replace oifinha = . if oifinha < 0
gen bequest = oifinha
replace bequest = 0 if bequest > 0 & bequest != . & bequest_from_HH_death == 1 //filter out inheritances due HH deaths
 
gen net_worth = hwnwip - hwnwin //household net worth

rename wlebf weight_2 //sampling weights
rename wlefj weight_6
rename wlejn weight_10
rename wlenr weight_14
gen overall_weight = 0
replace overall_weight = weight_2 if wave == 2
replace overall_weight = weight_6 if wave == 6
replace overall_weight = weight_10 if wave == 10
replace overall_weight = weight_14 if wave == 14

forvalues x = 1/45{ //replicate weights
	rename wlebf`x' r_weight_2_`x'
	rename wlefj`x' r_weight_6_`x'
	rename wlejn`x' r_weight_10_`x'
	rename wlenr`x' r_weight_14_`x'
	gen r_weight_overall_`x' = 0
	replace r_weight_overall_`x' = r_weight_2_`x' if wave == 2
	replace r_weight_overall_`x' = r_weight_6_`x' if wave == 6
	replace r_weight_overall_`x' = r_weight_10_`x' if wave == 10
	replace r_weight_overall_`x' = r_weight_14_`x' if wave == 14
}

gen child = 1 if hgage < 15 //generate equivalisation scale (OECD modified)
gen adult = 1 if hgage >= 15
egen total_child = total(child), by(hhrhid wave)
egen total_adult = total(adult), by(hhrhid wave)
gen equiv_scale = total_child*0.3 + total_adult*0.5 + 0.5 //0.3 for children, 1 for first adult and 0.5 for all subsequent adults

egen total_bequest = total(bequest), by(hhrhid wave)
gen bequest_e = total_bequest * 100 / (equiv_scale*CPI) //real equivalised gifts

gen net_worth_e = net_worth * 100 / (equiv_scale*CPI) //real equivalised net worth

gen net_worth_bequest_e = net_worth_e + F2.bequest_e + F3.bequest_e + F4.bequest_e

gen F2_4_bequest_e = F2.bequest_e + F3.bequest_e + F4.bequest_e

gen F2_4_bequest_e_positive = 0
replace F2_4_bequest_e_positive = 1 if F2_4_bequest_e > 0 //flag for an inheritance

gen flag = 1

drop if net_worth_bequest_e == . //drop cases where the person not in both waves, due to death or moving abroad (the weights don't adjust for this)

local wealth_waves 2 6 10 14
foreach x of local wealth_waves{
gen net_worth_e_`x' = net_worth_e if wave == `x'
gen net_worth_bequest_e_`x' = net_worth_bequest_e if wave == `x'
}

*****************************************************
*** Create program for jackknifing wealth measures **
*****************************************************

program jackknife_diff_pooled, eclass properties(svyj) //program for calculating the difference between summary measures of the distribution and jackknifing the 95% CI
syntax varlist [if/] [pweight iweight /] //specify standard syntax
tokenize `varlist' //sets `1', `2'

ineqdec0 `1' [aweight = `exp'] if `if' & `9' == 2
matrix gini_1 = r(gini)
matrix p90p10_1 = r(p90p10)
matrix p75p25_1 = r(p75p25)
matrix p25p50_1 = r(p25p50)
matrix p10p50_1 = r(p10p50)
matrix p90p50_1 = r(p90p50)
matrix p75p50_1 = r(p75p50)
matrix ge2_1 = r(ge2) 

ineqdec0 `2' [aweight = `exp'] if `if' & `9' == 6
matrix gini_2 = r(gini)
matrix p90p10_2 = r(p90p10)
matrix p75p25_2 = r(p75p25)
matrix p25p50_2 = r(p25p50)
matrix p10p50_2 = r(p10p50)
matrix p90p50_2 = r(p90p50)
matrix p75p50_2 = r(p75p50)
matrix ge2_2 = r(ge2)

ineqdec0 `3' [aweight = `exp'] if `if' & `9' == 10
matrix gini_3 = r(gini)
matrix p90p10_3 = r(p90p10)
matrix p75p25_3 = r(p75p25)
matrix p25p50_3 = r(p25p50)
matrix p10p50_3 = r(p10p50)
matrix p90p50_3 = r(p90p50)
matrix p75p50_3 = r(p75p50)
matrix ge2_3 = r(ge2) 

ineqdec0 `4' [aweight = `exp'] if `if' & `9' == 14
matrix gini_4 = r(gini)
matrix p90p10_4 = r(p90p10)
matrix p75p25_4 = r(p75p25)
matrix p25p50_4 = r(p25p50)
matrix p10p50_4 = r(p10p50)
matrix p90p50_4 = r(p90p50)
matrix p75p50_4 = r(p75p50)
matrix ge2_4 = r(ge2)

ineqdec0 `5' [aweight = `exp'] if `if' & `9' == 2
matrix gini_5 = r(gini)
matrix p90p10_5 = r(p90p10)
matrix p75p25_5 = r(p75p25)
matrix p25p50_5 = r(p25p50)
matrix p10p50_5 = r(p10p50)
matrix p90p50_5 = r(p90p50)
matrix p75p50_5 = r(p75p50)
matrix ge2_5 = r(ge2)
scalar C_5 = r(N) 

ineqdec0 `6' [aweight = `exp'] if `if' & `9' == 6
matrix gini_6 = r(gini)
matrix p90p10_6 = r(p90p10)
matrix p75p25_6 = r(p75p25)
matrix p25p50_6 = r(p25p50)
matrix p10p50_6 = r(p10p50)
matrix p90p50_6 = r(p90p50)
matrix p75p50_6 = r(p75p50)
matrix ge2_6 = r(ge2)
scalar C_6 = r(N) 

ineqdec0 `7' [aweight = `exp'] if `if' & `9' == 10
matrix gini_7 = r(gini)
matrix p90p10_7 = r(p90p10)
matrix p75p25_7 = r(p75p25)
matrix p25p50_7 = r(p25p50)
matrix p10p50_7 = r(p10p50)
matrix p90p50_7 = r(p90p50)
matrix p75p50_7 = r(p75p50)
matrix ge2_7 = r(ge2)
scalar C_7 = r(N)  

ineqdec0 `8' [aweight = `exp'] if `if' & `9' == 14
matrix gini_8 = r(gini)
matrix p90p10_8 = r(p90p10)
matrix p75p25_8 = r(p75p25)
matrix p25p50_8 = r(p25p50)
matrix p10p50_8 = r(p10p50)
matrix p90p50_8 = r(p90p50)
matrix p75p50_8 = r(p75p50)
matrix ge2_8 = r(ge2)
scalar C_8 = r(N) 

mean `1' [pweight = `exp'] if `if' & `9' == 2
matrix mean_1 = e(b)
matrix st_dev_1 = e(sd)

mean `2' [pweight = `exp'] if `if' & `9' == 6
matrix mean_2 = e(b)
matrix st_dev_2 = e(sd)

mean `3' [pweight = `exp'] if `if' & `9' == 10
matrix mean_3 = e(b)
matrix st_dev_3 = e(sd)

mean `4' [pweight = `exp'] if `if' & `9' == 14
matrix mean_4 = e(b)
matrix st_dev_4 = e(sd)

mean `5' [pweight = `exp'] if `if' & `9' == 2
matrix mean_5 = e(b)
matrix st_dev_5 = e(sd)

mean `6' [pweight = `exp'] if `if' & `9' == 6
matrix mean_6 = e(b)
matrix st_dev_6 = e(sd)

mean `7' [pweight = `exp'] if `if' & `9' == 10
matrix mean_7 = e(b)
matrix st_dev_7 = e(sd)

mean `8' [pweight = `exp'] if `if' & `9' == 14
matrix mean_8 = e(b)
matrix st_dev_8 = e(sd)

matrix gini_diff = gini_5 + gini_6 + gini_7 + gini_8 - (gini_1 + gini_2 + gini_3 + gini_4)
matrix ge2_diff = ge2_5 + ge2_6 + ge2_7 + ge2_8 - (ge2_1 + ge2_2 + ge2_3 + ge2_4) 
matrix abs_gini_diff =  gini_5 * mean_5 + gini_6 * mean_6 + gini_7 * mean_7 + gini_8 * mean_8 - (gini_1 * mean_1 + gini_2 * mean_2 + gini_3 * mean_3 + gini_4 * mean_4)
matrix st_dev_diff = st_dev_5 + st_dev_6 + st_dev_7 + st_dev_8 - (st_dev_1 + st_dev_2 + st_dev_3 + st_dev_4)
matrix p90p10_diff = p90p10_5 + p90p10_6 + p90p10_7 + p90p10_8 - (p90p10_1 + p90p10_2 + p90p10_3 + p90p10_4)
matrix p75p25_diff = p75p25_5 + p75p25_6 + p75p25_7 + p75p25_8 - (p75p25_1 + p75p25_2 + p75p25_3 + p75p25_4)
matrix p25p50_diff = p25p50_5 + p25p50_6 + p25p50_7 + p25p50_8 - (p25p50_1 + p25p50_2 + p25p50_3 + p25p50_4)
matrix p10p50_diff = p10p50_5 + p10p50_6 + p10p50_7 + p10p50_8 - (p10p50_1 + p10p50_2 + p10p50_3 + p10p50_4)
matrix p90p50_diff = p90p50_5 + p90p50_6 + p90p50_7 + p90p50_8 - (p90p50_1 + p90p50_2 + p90p50_3 + p90p50_4)
matrix p75p50_diff = p75p50_5 + p75p50_6 + p75p50_7 + p75p50_8 - (p75p50_1 + p75p50_2 + p75p50_3 + p75p50_4)

gen sample = 0
replace sample = 1 if `if' & `exp' != 0 & (`5' != . | `6' != . | `7' != . | `8' != .)

scalar C = C_5 + C_6 + C_7 + C_8

matrix b = (gini_diff, ge2_diff, abs_gini_diff, st_dev_diff, p90p10_diff, p75p25_diff, p25p50_diff, p10p50_diff, p90p50_diff, p75p50_diff)

matrix colnames b = gini_diff ge2_diff abs_gini_diff st_dev_diff p90p10_diff p75p25_diff p25p50_diff p10p50_diff p90p50_diff p75p50_diff

matrix list b

ereturn post b, esample(sample)
ereturn scalar N = C

end

*****************************************
*** Compute jackknifed wealth measures **
*****************************************

svyset [pweight = overall_weight], jkrweight(r_weight_overall_*, multiplier(0.977777)) vce(jackknife) mse
svy jackknife: jackknife_diff_pooled net_worth_e_2 net_worth_e_6 net_worth_e_10 net_worth_e_14 net_worth_bequest_e_2 net_worth_bequest_e_6 net_worth_bequest_e_10 net_worth_bequest_e_14 wave

